// BER Performance coamparison with one receivivng atenna and two receiving antennas with Maximal ratio Combining diversity technique over awgn channe and rayleigh fading channel
clc;
clear;
xdel(winsid());
sym=100000;// no. of symbols
M=2;
data1=grand(1,sym,"uin",0,1);// input signal is randomly generated
//N = 10; % number of bits or symbols
//ip = rand(1,N)>0.5; % generating 0,1 with equal probability
s = 2*data1-1; // BPSK modulation 0 -> -1; 1 -> 1
nRx = [1 2];//no of receivers
snr_dB =   [1:20]; // signal to noise ration in dB
for jj = 1:length(nRx)
    for ii = 1:length(snr_dB)
        n = 1/sqrt(2)*[rand(nRx(jj),sym,'normal') + %i*rand(nRx(jj),sym,'normal')]; //white gaussian noise,
        h = 1/sqrt(2)*[rand(nRx(jj),sym,'normal') + %i*rand(nRx(jj),sym,'normal')]; // Rayleigh fading channel
        // Channel and noise Noise addition
        sD = kron(ones(nRx(jj),1),s);
        y = h.*sD + 10^(-snr_dB(ii)/20)*n;// received signal over awgn channel and ayleigh fading channel
        // finding the power of the channel on all rx chain
         yHat =  sum(conj(h).*y,1)./sum(h.*conj(h),1); // maximal ratio combining
       // hPower1 = h.*conj(h);  
       
        ipHat = real(yHat)>0;
        // effective SNR
                nErr(jj,ii) = size(find([data1- ipHat]),2);//calculate error
            end
end
simBer = nErr/sym; //bit error rate calculation
// plot
snr_dB=1:20
plot2d(snr_dB,simBer(1,:),5,logflag="nl");//snr- ber plot with one receiving antenna
plot2d(snr_dB,simBer(2,:),2,logflag="nl");//snr- ber plot with two receiving antennas
//plot(nRx,10*log10(EbN0EffSim),'bp-','LineWidth',2);
//mtlb_axis([1 20 0 6])
xgrid
legend(['1X1';'1X2']);
xlabel('Number of receive antenna');
ylabel('effective SNR, dB');
title('SNR improvement with Maximal ratio Combining');

